using System;
using System.Data;
using System.Data.SqlClient;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>03/13/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// Provides required functionality to implement data persistence 
		/// logic for blood unit media (BOL.BoodUnitMedia).
		/// Exposes set of public static methods to retrieve blood unit media 
		/// data and store it to the VBECS database.
		///</summary>

		#endregion

	public class BloodUnitMedia
	{


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/10/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7495"> 
		///		<ExpectedInput>True</ExpectedInput>
		///		<ExpectedOutput>DataTable with RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7496"> 
		///		<ExpectedInput>False</ExpectedInput>
		///		<ExpectedOutput>DataTable without RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// spInsertBloodUnitMedia, spUpdateBloodUnitMedia
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static DataTable GetEmptyBloodUnitMediaTableSchema(bool isUpdate)
		{
			DataTable dtBloodUnitMedia = new DataTable(TABLE.BloodUnitMedia.TableName);

			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.BloodUnitMediaGuid, typeof(System.Guid));
			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.TestingStatusId, typeof(int));
			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.BloodTypeCode, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.RhFactorCode, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.UnitExpirationDate, typeof(System.DateTime));
			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.DirectedPatientGuid, typeof(System.Guid));
			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnit.DivisionCode, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.Comments, typeof(string));

			if (isUpdate)
			{
				dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.RemoveRestrictionDate, typeof(System.DateTime));
				dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.RemoveRestrictionTechId, typeof(string));
				dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.RowVersion, typeof(byte[]));
			}
			else
			{	
				dtBloodUnitMedia.Columns.Add(TABLE.BloodUnitMedia.BloodUnitGuid, typeof(System.Guid));	
			}

			return(dtBloodUnitMedia);
		}



		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="887"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>BloodUnitMedia information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="900"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetBloodUnitMediaByGuid
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataTable GetBloodUnitMediaByGuid(System.Guid bloodUnitGuid)
        {
            SqlParameter[] prms =
            {
                new SqlParameter(STOREDPROC.GetBloodUnitMediaByUnitGuid.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
                new SqlParameter(STOREDPROC.GetBloodUnitMediaByUnitGuid.divisioncode, System.Data.SqlDbType.Char)
			};

            prms[0].Value = bloodUnitGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
             	
			System.Data.DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitMediaByUnitGuid.StoredProcName, prms).Tables[0];

			dt.Columns[TABLE.TestingStatus.TestingStatusId].AutoIncrement = false;
			dt.Columns[TABLE.TestingStatus.TestingStatusId].AllowDBNull = true;
			dt.AcceptChanges();

			return dt;
        }
        
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="914"> 
		///		<ExpectedInput>PatientGuid</ExpectedInput>
		///		<ExpectedOutput>BloodUnit Information for patient</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="919"> 
		///		<ExpectedInput>Invalid PatientGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetBloodUnitsByPatient
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataTable GetBloodUnitsByPatient(System.Guid patientGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetBloodUnitsByPatient.directedpatientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetBloodUnitsByPatient.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = patientGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitsByPatient.StoredProcName, prms).Tables[0];		
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="924"> 
		///		<ExpectedInput>PatientGuid, ComponentClassID</ExpectedInput>
		///		<ExpectedOutput>Specific BloodUnit Information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="925"> 
		///		<ExpectedInput>Invalid PatientGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetBloodUnitsByPatient
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <param name="componentClassId"></param>
		/// <returns></returns>
		public static DataTable GetBloodUnitsByPatient(System.Guid patientGuid, int componentClassId)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetBloodUnitsByPatientAndComponentClassID.directedpatientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetBloodUnitsByPatientAndComponentClassID.componentclassid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.GetBloodUnitsByPatientAndComponentClassID.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = patientGuid;
			prms[1].Value = componentClassId;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitsByPatientAndComponentClassID.StoredProcName, prms).Tables[0];		
		}
		/// <summary>
		/// Implements BR_11.21 to release the restriction of a unit that is volunteer allogeneic V 
		/// </summary>
		/// <param name="dtUnit"></param>
		/// <param name="lastUpdateFunctionId"></param>
		/// <returns></returns>
		///<Case type="0" testid ="8947"> 
		///		<ExpectedInput>Valid data table and valid update function id</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8948"> 
		///		<ExpectedInput>DataRow with Invalid RowVersion</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///
		public static bool ReleaseRestriction(DataTable dtUnit, Common.UpdateFunction lastUpdateFunctionId)
		{
			if (lastUpdateFunctionId == Common.UpdateFunction.Invalid)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("last update function id").ResString);
			}
			//
			System.Collections.ArrayList dtArray = new System.Collections.ArrayList();
			System.Collections.ArrayList spArray = new System.Collections.ArrayList();
			//
			
			spArray.Add(STOREDPROC.ReleaseRestriction.StoredProcName);
			dtArray.Add(Common.Utility.AppendLastUpdateInformation(dtUnit, lastUpdateFunctionId));
			//
			return ( (new StoredProcedure()).TransactionalGetValue( spArray, dtArray ) == 0 );
		}

		
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/12/2011</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="9215"> 
		///		<ExpectedInput>Valid blood unit guid</ExpectedInput>
		///		<ExpectedOutput>data table with one row of data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="9216"> 
		///		<ExpectedInput>empty blood unit guid</ExpectedInput>
		///		<ExpectedOutput>data table with no rows</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetBloodUnitMediaDirectedPatientByGuid returns everything necessary for us to later
		/// retore the restriction that was dropped from BR_11.21 
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static DataTable GetBloodUnitMediaDirectedPatientByGuid(System.Guid bloodUnitGuid)
		{
			//CR 3180
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetMirrorBloodUnitMediaDirectedPatient.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
			};
			prms[0].Value = bloodUnitGuid;
			System.Data.DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetMirrorBloodUnitMediaDirectedPatient.StoredProcName, prms).Tables[0];
			return dt;
		}
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="926"> 
		///		<ExpectedInput>DataRow with Valid Rowvserion</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="927"> 
		///		<ExpectedInput>DataRow with Invalid RowVersion</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Save
		/// </summary>
		/// <param name="bloodUnitMediaDataRow"></param>
		/// <returns></returns>
		public static bool Save(DataRow bloodUnitMediaDataRow)
        {
			int retValue = new Common.StoredProcedure().TransactionalGetValue(STOREDPROC.UpdateBloodUnitMedia.StoredProcName, bloodUnitMediaDataRow);

			return(retValue == 0);
        }		

    }
}
